//								EJEMPLO 15
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//La memoria EEPROM de datos.La mquina "SU TURNO"
//
//Se trata de emular el funcionamiento de las mquinas tipo "SU TURNO" habituales en mltiples
//comercios. Sobre el display se visualizar el nmero del turno actual. Este se icrementa a
//cada pulso aplicado por RA0. En la memoria EEPROM del PIC16F876 se almacena el ltimo nmero
//visualizado, de forma que, ante un fallo de alimentacin (p.e.), se reanude la cuenta en el
//ltimo nmero.

//Si se parte de que el sistema se emplea por vez primera , se visualiza el 0

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)

int	contador;

main()
{  
	unsigned int const display[16]={0x3F,0x06,0x5B,0x4F,// Al ser una tabla constante
                               0x66,0x6D,0x7D,0x07,		// se crea dentro de la memoria
                               0x7F,0x6F,0x77,0x7C,		// de programa.
                               0x39,0x5E,0x79,0x71};

	SETUP_ADC_PORTS(NO_ANALOGS);	//Puerta A Digital
	set_tris_a(0x3F);				//RA0-RA5 entradas
	set_tris_b(0x00);				//RB0-RB7 salidas	   
	contador = read_eeprom(0x00);	//Lee contador de la EEPROM
	if (contador > 9)
	contador= 0x00;					//Ajusta el contador si es mayor de 9

	while(1)
	{
	output_b(display[contador&0x0f]);	//Visualiza el contador
	while(input(PIN_A0));			//Esperar pulso 1-0-1 en RA0
	delay_ms(10);					//Temporizar para eliminar rebotes
	while(!input(PIN_A0));
	delay_ms(10);				
	contador++;						//Incrementa el contador
	if(contador>9)
	contador=0x00;					//Ajusta a 0 el contador
	write_eeprom(0x00,contador);	//Lo salva en la EEPROM
	}
}	
